from mail.python.theatre.app.settings import SettingsNode

from mail.callmeback.callmeback.settings.db import MultihostDbSettings

from .event_api import EventApiSettings
from .event_buffer import EventBufferSettings
from .force_insert import InsertionForcerSettings
from .log import LogSettings
from .tvm import TvmSettings
from .worker_monitor import WorkerMonitorSettings
from .worker_notifier import WorkerNotifierSettings


class Settings(SettingsNode):
    db = MultihostDbSettings()
    event_api = EventApiSettings()
    event_buffer = EventBufferSettings()
    insertion_forcer = InsertionForcerSettings()
    log = LogSettings()
    tvm = TvmSettings()
    worker_monitor = WorkerMonitorSettings()
    worker_notifier = WorkerNotifierSettings()
