from mail.callmeback.callmeback.stages.worker.settings.skipped_event_finder import SkippedEventFinderSettings
from mail.python.theatre.roles import Cron
from .event_poller import EventPoller


class SkippedEventFinder(Cron):
    """Forces reload of events info on regular basis, for unpredicted events loss cases"""
    def __init__(self, events_poller: EventPoller, settings: SkippedEventFinderSettings):
        self.events_poller = events_poller
        super(SkippedEventFinder, self).__init__(job=self.drop_cache, **settings.cron.as_dict())

    async def drop_cache(self):
        await self.events_poller.find_skipped()
