import logging
import datetime
from typing import Any

import ujson
from dataclasses import dataclass, field

log = logging.getLogger(__name__)


@dataclass
class CallbackItem:
    """Database event info representation"""
    cb_url: str
    event_id: int
    bucket_id: int
    group_key: str
    event_key: str
    owner_client_id: int
    status: str
    tries: int
    run_at: datetime.datetime
    originally_run_at: datetime.datetime = field(repr=False)
    created_at: datetime.datetime = field(repr=False)
    context: Any = field(default=None, repr=False)
    quick_tries: int = 0

    def __post_init__(self):
        self.context = ujson.loads(self.context)

    @property
    def notify_scheme(self):
        if self.context:
            return self.context.get('notify_scheme')

    @property
    def retry_params(self):
        if self.context:
            return self.context.get('retry_params', {})
        return {}
