from mail.python.theatre.app.settings import SettingsNode

from mail.callmeback.callmeback.settings.db import MultihostDbSettings

from .bucket_holder import BucketHolderSettings
from .event_marker import EventMarkerSettings
from .event_poller import EventPollerSettings
from .herald import CallbackHeraldSettings
from .host_stats import HostStatsSettings
from .limit import LimitSettings
from .log import LogSettings
from .naive_schedule_planner import NaiveSchedulePlannerSettings
from .notifier import NotifierSettings
from .skipped_event_finder import SkippedEventFinderSettings
from .tvm import TvmSettings


class Settings(SettingsNode):
    bucket_holder = BucketHolderSettings()
    callback_herald = CallbackHeraldSettings()
    db = MultihostDbSettings()
    event_marker = EventMarkerSettings()
    event_poller = EventPollerSettings()
    host_stats = HostStatsSettings()
    limit = LimitSettings()
    log = LogSettings()
    naive_schedule_planner = NaiveSchedulePlannerSettings()
    notifier = NotifierSettings()
    skipped_event_finder = SkippedEventFinderSettings()
    tvm = TvmSettings()
