from datetime import timedelta

from mail.python.theatre.app.settings import DelayedSettings, SettingsNode, QueuedSettings
from mail.callmeback.callmeback.detail.retry_params import ConstantRetryStrategy, RetriesLimit, QuickRetries


class CallbackHeraldSettings(SettingsNode):
    delayed = DelayedSettings(max_delayed=10 * 1000, retry_delayed=timedelta(milliseconds=100))
    queued = QueuedSettings(servant_count=50, maxsize=1000)
    quick_retries_delay = timedelta(seconds=1)
    max_host_problem_coeff: float = 0.666
    max_delayed_per_host: int = 1000
    quick_retries = QuickRetries(5)
    retries_limit = RetriesLimit(timedelta(days=5))
    retry_strategy = ConstantRetryStrategy(timedelta(seconds=60))

    def local(self):
        self.quick_retries_delay = timedelta(milliseconds=10)
        self.queued = QueuedSettings(servant_count=2, maxsize=10)

    def devpack(self):
        self.local()

    def docker(self):
        self.local()
