#include <mail/callmeback/client/callmeback_client.h>
#include <yamail/data/serialization/json_writer.h>
#include <butil/datetime/date_utils.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>

using namespace std::string_literals;

namespace callmeback {

struct ClientRequest {
    std::string run_at;
    std::string cb_url;
    std::string group_key;
    std::string event_key;
    std::string notify_scheme = "http";

    struct Context {
        struct Http {
            std::string method = "post";
            http::headers::FlatMap headers;
            HttpArguments::FlatArguments params;
            std::string data;
        } _http;
        RetryParamsOptional retry_params;
    } context;
};

}

BOOST_FUSION_ADAPT_STRUCT(callmeback::ClientRequest::Context::Http,
    (std::string, method)
    (http::headers::FlatMap, headers)
    (HttpArguments::FlatArguments, params)
    (std::string, data)
)

BOOST_FUSION_ADAPT_STRUCT(callmeback::RetryParams,
    (std::optional<std::string>, strategy)
    (std::optional<std::time_t>, base_delay)
    (std::optional<float>, delay_growth_rate)
    (std::optional<uint>, quick_retries_count)
    (std::optional<std::time_t>, stop_after_delay)
)

BOOST_FUSION_ADAPT_STRUCT(callmeback::ClientRequest::Context,
    (callmeback::ClientRequest::Context::Http, _http)
    (callmeback::RetryParamsOptional, retry_params)
)

BOOST_FUSION_ADAPT_STRUCT(callmeback::ClientRequest,
    (callmeback::ClientRequest::Context, context)
    (std::string, run_at)
    (std::string, cb_url)
    (std::string, group_key)
    (std::string, event_key)
    (std::string, notify_scheme)
)


namespace callmeback {

std::string Client::formatDate(std::time_t date) {
    return DateUtils::tztime2string(date, "UTC+0", "%Y-%m-%dT%H:%M:%SZ");
}

std::string Client::generateRequestBody(const std::string& uid, const std::string& id, const std::string& runAt,
                                const Request& request) const {
    ClientRequest rem;
    rem.run_at = runAt;
    rem.cb_url = callbackHost_ + request.path;
    rem.group_key = uid;
    rem.event_key = id;
    rem.context.retry_params = request.retryArgs;
    rem.context._http.headers = request.headers.flatten();
    rem.context._http.params = request.getArgs.flatten();
    rem.context._http.data = request.postArgs.format();

    return yamail::data::serialization::toJson(rem).str();
}

}
