#pragma once

#include <mail/callmeback/client/request.h>
#include <mail/http_getter/client/include/client.h>


namespace callmeback {


using Mid = std::string;

struct ClientConfig {
    http_getter::TypedEndpoint add;
    http_getter::TypedEndpoint update;
    http_getter::TypedEndpoint cancel;
};

struct Client {
    Client(const ClientConfig& config, std::string callbackHost, const http_getter::TypedClient& http)
        : config_(config)
        , callbackHost_(std::move(callbackHost))
        , http_(http)
    { }

    template <typename Type>
    auto set(const std::string& uid, const Mid& mid, Type type, const std::string& runAt,
                               const Request& request, bool update) {
        const std::string id = generateId(type, mid);
        const http_getter::TypedEndpoint& endpoint = update ? config_.update : config_.add;
        auto resp = http_.toPOST(format(endpoint, uid, id))
            .body(generateRequestBody(uid, id, runAt, request));

        if (update) {
            using namespace http_getter::detail::operators;
            resp.getArgs("ensure_pending"_arg="true");
        }

        return http_.req(resp);
    }

    template <typename Type>
    auto remove(const std::string& uid, Type type, const Mid& mid) {
        const std::string id = generateId(type, mid);
        return  http_.req(http_.toPOST(format(config_.cancel, uid, id)));
    }

    static std::string formatDate(std::time_t date);

private:
    template <typename Type>
    static std::string generateId(Type type, const Mid& mid) {
        return fmt::format("{}_{}", toString(type), mid);
    }

    static http_getter::TypedEndpoint format(const http_getter::TypedEndpoint& endpoint, const std::string& uid, const std::string& id) {
        return endpoint.format(
            fmt::arg("uid", uid),
            fmt::arg("reminder_id", id)
        );
    }

    std::string generateRequestBody(const std::string& uid, const std::string& id, const std::string& runAt,
                                const Request& request) const;

    const ClientConfig& config_;
    std::string callbackHost_;
    const http_getter::TypedClient& http_;
};

}
