#pragma once

#include <butil/http/arguments.h>
#include <butil/http/headers.h>

namespace callmeback {

class RetryParamsBuilder;

struct RetryParams {
    std::optional<std::string> strategy;
    std::optional<std::time_t> base_delay;
    std::optional<std::time_t> stop_after_delay;
    std::optional<uint> quick_retries_count;
    std::optional<float> delay_growth_rate;
};
class RetryParamsBuilder {
public:
    RetryParamsBuilder& delay(std::time_t delay) {
        data_.base_delay = delay;
        return *this;
    }
    RetryParamsBuilder& stopAfter(std::time_t delay) {
        data_.stop_after_delay = delay;
        return *this;
    }
    RetryParamsBuilder& retries(uint retries) {
        data_.quick_retries_count = retries;
        return *this;
    }
    RetryParamsBuilder& growthRate(float growthRate) {
        data_.delay_growth_rate = growthRate;
        return *this;
    }
    RetryParams& data() {
        return data_;
    }
protected:
    RetryParams data_;
    RetryParamsBuilder() = default;
};

class RetryParamsConst : public RetryParamsBuilder {
public:
    RetryParamsConst() {
        data_.strategy = "constant";
    }
};
class RetryParamsExp : public RetryParamsBuilder {
public:
    RetryParamsExp(std::time_t base_delay, float delay_growth_rate) {
        data_.strategy = "exponential";
        data_.base_delay = base_delay;
        data_.delay_growth_rate = delay_growth_rate;
    }
};



using RetryParamsOptional = std::optional<RetryParams>;

struct Request {
    std::string path;
    HttpArguments getArgs;
    http::headers headers;
    HttpArguments postArgs;
    RetryParamsOptional retryArgs;
};

}
