import requests

from mail.devpack.lib import helpers
from mail.devpack.lib.components.base import SubprocessComponent, WithPort

from .db import CallmebackDb


class CallmebackApi(SubprocessComponent, WithPort):
    NAME = "callmeback-api"
    DEPS = [CallmebackDb]

    def __init__(self, env, components):
        super().__init__(env, components)
        self.bin_file = env.get_arcadia_bin('mail/callmeback/bin/api/callmeback-api')

    def init_root(self):
        helpers.mkdir_recursive(self.log_dir)

    def start(self):
        cmd = [self.bin_file, '--env', 'devpack', '--port', str(self.port)]
        env = {'CALLMEBACKDB_PORT': str(self.components[CallmebackDb].port())}
        with self.starting(cmd, env):
            helpers.wait_ping(self.logger, self.healthcheck)

    @property
    def hostport(self):
        return f"http://localhost:{self.port}"

    # TODO :: move this to client class
    def healthcheck(self, timeout=1):
        url = f"{self.hostport}/unistat"
        self.logger.info('GET request, url: %s', url)
        return requests.get(url, timeout=timeout)

    def info(self):
        return {
            "bin_file": self.bin_file,
            **super().info()
        }
