from mail.devpack.lib.components.postgres import Postgres


class CallmebackDb(Postgres):
    NAME = "callmebackdb"
    POSTGRE_FILES_PREFIX = 'resfs/file/mail/callmeback/postgre'

    before_all_prefixes = [
        f'{POSTGRE_FILES_PREFIX}/drops',
    ]

    after_all_prefixes = [
        f'{POSTGRE_FILES_PREFIX}/impl',
        f'{POSTGRE_FILES_PREFIX}/code',
        f'{POSTGRE_FILES_PREFIX}/grants',
    ]

    migration_prefixes = [
        f'{POSTGRE_FILES_PREFIX}/migrations',
    ]

    snapshot_sql_files = [
        f'{POSTGRE_FILES_PREFIX}/callmebackdb.sql',
    ]

    def __init__(self, env, _):
        users = ['callmeback']
        self.init_from_conf(env.get_config(), self.name, users)

    def prepare_data(self):
        super().prepare_data()
        self.execute('''
            INSERT INTO reminders.buckets (
                SELECT x from generate_series(1, 10) x
            )
        ''')
