### Особенности реализации сервиса CallMeBack

#### Структура БД
Данные сервиса хранятся в БД Postgress
На текущий момент разделения на корп и прод - нету.

Основные таблицы:
* reminders.events - основная таблица для хранения событий
* reminders.change_log - тут хранятся изменения событий пользователями(обновление, удаление, отмена)
* reminders.schedules - таблица для создания событий по расписанию
* reminders.scheduled_events - вспомогательная таблица для генерации событий по расписанию
* reminders.buckets - таблица для распределения событий по разным воркерам(каждому событию при создании присваивается
  bucket_id некоторого существующего бакета, каждый бакет обрабатывается одним воркером)

События могут находиться в статусе:
* pending - событие запланировано и ожидает выполнения
* notified - событие выполнено
* failed - не смогли успешно выполнить событие, пока оно не устарело (т.е. запланированное время + stop_after_delay)
* cancelled - пользователь отменил событие
* rejected - сервис, который выполнял колбек вернул reject (передал в хидерах X-Ya-CallMeBack-Notify-Reject)


#### Удаление, отмена и обновление событий
Эти операции работают для события заданного набором owner_client_id + group_key + event_key
* при удалении события, если не задан флаг force, событие в состоянии pending и время наступления события
  меньше чем через 1 минуту, то возвращаем ошибку, иначе удаляем;
* при отмене события разрешаем отменять только pending события;
* при обновлении события можно обновить поля run_at/originally_run_at, cb_url, context;
  разрешаем отменять только pending события или, если передан флаг i_ensure_pending, то можно обновить еще и cancel
  события, при этом они переведутся в pending


#### Авточистка событий
Есть джоба шивы callmebackdb/clean?[ttl_days], которая чистит все устаревшие события (т.е. status != 'pending' и run_at < now() - ttl_days)
и change_log (at < now() - ttl_days). По умолчанию ttl_days = 30. Джоба запускается вечером каждый день


#### Ретраи
Клиент может настроить политику ретраев.
* Можно настроить время протухания события, т.е. если после наступления времени события оно не смогло выполниться со всеми ретраями
  за заданное время, то событие считается протухшим, переводится в сотояние failed и больше не ретрается
* Можно настроить кол-во быстрых ретраев или отключить их. Под быстрыми подразумеваются ретраи, которые делаются
  без решедулинга времени события в базе и делаются очень быстро
* Можно настроить тип и параметры основных ретраев. Это ретраи, которые делаются с большей задержкой и путем решедулинга в базе времени события.
  Сейчас реализованы два типа ретраев: константные (т.е. через одинаковое время, например через каждые 60 сек(используется по дефолту)) и экспоненциальные(т.е. когда с каждым ретраем задержка вырастает
  в заданное кол-во раз, т.е. задержки между ретраями будут например 1 минута, 2, 4, 8, 16 ...)
Пример задания клиентом этих параметров можно посмотреть в howto


#### Алгоритм работы
Подробное описание принципов по которым выбираются события для обработки из базы описано [в статье Васила на хабре](https://habr.com/ru/company/yandex/blog/471012/) 

Вкратце попробую описать основные моменты.
* Времена событий могут совпадать, поэтому при выборке событий мы их будем сортировать по run_at + event_id.
  Соответственно у нас для быстрой выборки нужных событий есть условный индекс по
  (bucket_id, run_at, event_id) WHERE status = 'pending'
* События могут добавляться и в прошлом и их тоже надо обрабатывать (т.е. просто выбирать события по возрастанию
   run_at + event_id не подходит)

Таким образом алгоритм сейчас работает так:
* Раз в секунду кроновая джоба делает выборку событий для нотификации и помещает их в очередь на обработку.
* При этом мы храним max_run_at и max_event_id уже выбранных событий
* Выборка событий делается 2мя запросами:
  1й - выбирает подходящие заранее запланированные события, упорядоченные по времени и event_id:
    WHERE status = 'pending'
      AND (run_at, event_id) > (:max_run_at, :max_event_id)
      AND run_at <= now() + interval '2 seconds'
    ORDER BY run_at, event_id
  2й - выбирает события, которые запланированы в прошлом(т.е. добавлены уже после наступления времени самого события):
    WHERE status = 'pending'
      AND run_at <= :max_run_at
      AND event_id > :max_event_id
    ORDER BY event_id
* При поиске событий, которые запланированы в прошлом, мы должны обеспечить, чтобы event_id монотонно рос
  при добавлении таких событий, что при параллельных транзакциях может нарушаться. Чтобы избежать нарушения монотонного
  роста event_id, при добавлении событий в базу берется advisory_xact_lock, из-за чего могут быть определенные проблемы
  с производительностью(так как разные инстансы api колмибеков могут ждать на локах)
* Чтобы оптимизировать добавление событий в базу, они вначале буферизируются и затем пачкой пишутся в базу (либо когда накопится
  нужное кол-во, либо через 50мс). Соответственно клиентам отвечаем, когда запишем события в базу.

