#### Как запустить тесты

Прежде чем делать то, что ниже, стоит убедиться, что у Вас правильно резолвится localhost
на ipv6, для этого идем в /etc/hosts и проверяем, что там записано по адресу ::1. Важно, чтобы
там помимо всего прочего фигурировал localhost. 

Для начала надо запустить из корневого каталога базу, чтобы она работала:

> docker-compose up db

Далее (исходим из того, что Вы работаете в PyCharm), идем в Run -> Edit configurations,
создаем новую конфигурацию на основе Python и называем ее Api testing. В качестве Target выбираем
`Module name` и указываем `callmeback.stages.api.main`. В качестве `Parameters` указываем
`--port 8686 --env local` (здесь важно, что порт должен быть именно этот, поскольку на него завязаны тесты).

В качестве `Working directory` можно указать что угодно, хоть текущую директорию. По итогам туда будут писаться
логи. 

Далее создаем так же конфигурацию Worker testing. Ей в качестве `Module name` указываем `callmeback.stages.worker.main`, а
в качестве `Parameters` значение `--port 8787 --env local` (опять же порт надо указывать именно такой, поскольку он прописан 
намертво в тестах). Насчет `Working directory` то же самое, что и выше. 

Осталось создать тестовую конфигурацию на основе шаблона `Python tests`. Ей в качестве `Module` указываем 
`tests.integration`. В качестве `Additional arguments` можно указать `-x`, чтобы он останавливался на первом же провальном тесте.
Внизу можно увидеть предупреждение от PyCharm типа `Warning: No pytest runner found in selected interpreter`, 
однако его можно проигнорировать.

Ну вот и все. Далее нужно сначала запустить первые две конфигурации, а затем тесты, и убедиться что всё проходит. 