#!/bin/bash

source /usr/lib/qloud-functions.sh

SERVICE_COMPONENT=${SERVICE_COMPONENT:-"callmeback-${QLOUD_COMPONENT}"}

if [[ -z $SERVICE_COMPONENT ]] ; then
    echo "SERVICE_COMPONENT env variable must be set"
    return 1
fi

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        echo "Ephemeral found"
        check_ephemeral &&
        (
          qloud_log yamail-logs
          qloud_log yandex
          qloud_log nginx
          qloud_log $SERVICE_COMPONENT
        )

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 2
    fi
done
        
if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral"
fi

mkdir -p /var/log/$SERVICE_COMPONENT
mkdir -p /var/log/nginx
mkdir -p /var/log/nginx/callmeback

chmod 644 /etc/logrotate.d/*
chmod 644 /etc/cron.d/*
