#!/bin/bash

# Проверка наличия смонитрованого эфимерного диска:
function check_ephemeral() {
    mount | grep -q "/ephemeral"
}

# Симлинки каталогов с логами в эфимерный диск:
function qloud_log {
# Usage: qloud_logs foldername [user:group]
    if [ -z $1 ];then
        echo "Directory missing!"
        return 1
    fi
    rm -rf "/var/log/$1"
    mkdir -pv "/ephemeral/log/$1" || true
    ln -sfv "/ephemeral/log/$1" /var/log/
    ([[ $2 ]] && chown -Rv $2 /ephemeral/log/$1) || true

}
