CREATE TYPE code.cancel_event_error AS ENUM (
    'not_found',
    'already_cancelled',
    'illegal_status'
);

CREATE TYPE code.cancel_event_result as (
    err code.cancel_event_error,
    old_status reminders.event_status,
    new_rec reminders.events
);

create or replace function code.cancel_event(
    i_owner_client_id int,
    i_group_key text,
    i_event_key text
) RETURNS code.cancel_event_result as $$
DECLARE
  v_id bigint;
  v_status reminders.event_status;
  v_new_rec reminders.events;
BEGIN
  SELECT status, event_id
    INTO v_status, v_id
    FROM reminders.events
   WHERE COALESCE(owner_client_id, -1) = COALESCE(i_owner_client_id, -1)
     AND group_key = i_group_key
     AND event_key = i_event_key
  FOR NO KEY UPDATE;

  if not found then
    return ('not_found', null, null)::code.cancel_event_result;
  end if;

  if v_status = 'cancelled' then
    return ('already_cancelled', v_status, null)::code.cancel_event_result;
  end if;

  if v_status != 'pending' then
    return ('illegal_status', v_status, null)::code.cancel_event_result;
  end if;

  UPDATE reminders.events
     SET status = 'cancelled'
   WHERE event_id = v_id
  RETURNING *
  INTO v_new_rec;
  return (null, v_status, v_new_rec)::code.cancel_event_result;
END;
$$ language plpgsql;