CREATE TYPE code.delete_event_error AS ENUM (
    'not_found',
    'too_close_to_run'
);

CREATE TYPE code.delete_event_result as (
    err code.delete_event_error,
    rec reminders.events
);


create or replace function code.delete_event(
    i_owner_client_id int,
    i_group_key text,
    i_event_key text,
    i_min_run_at timestamptz default null,
    i_force bool default false
) RETURNS code.delete_event_result as $$
DECLARE
  v_rec reminders.events;
BEGIN
  SELECT *
    INTO v_rec
    FROM reminders.events
   WHERE COALESCE(owner_client_id, -1) = COALESCE(i_owner_client_id, -1)
     AND group_key = i_group_key
     AND event_key = i_event_key;

  if not found then
    return ('not_found', null)::code.delete_event_result;
  end if;

  if not i_force and v_rec.status = 'pending' and v_rec.run_at < i_min_run_at then
    return ('too_close_to_run', v_rec)::code.delete_event_result;
  end if;

  DELETE FROM reminders.events
   WHERE event_id = v_rec.event_id;

  if found then
    INSERT INTO reminders.change_log (
      event_id, owner_client_id, event_key, group_key, change_type, event_data
    )
    VALUES (
      v_rec.event_id, v_rec.owner_client_id, v_rec.event_key, v_rec.group_key, 'delete', v_rec
    );
  end if;

  return (null, v_rec)::code.delete_event_result;
END;
$$ language plpgsql;