create schema reminders;

CREATE TYPE reminders.event_status AS ENUM (
    'pending',
    'notified',
    'failed',
    'cancelled'
);

CREATE TABLE reminders.events (
    -- PK
    event_id   bigserial primary key,
    -- Microshard FK
    bucket_id  integer,
    -- External keys
    event_key  text,
    group_key  text,
    -- Payload data
    run_at     timestamptz,
    context    jsonb,
    cb_url     text,
    -- Internal data
    owner_client_id bigint,
    created_at timestamptz not null default now(),
    status     reminders.event_status not null default 'pending'
);

CREATE INDEX ix_events_by_bucket_id_run_at ON reminders.events(bucket_id, run_at, event_id)
    WHERE status = 'pending';

CREATE UNIQUE INDEX ux_events_by_keys ON reminders.events(owner_client_id, group_key, event_key)
    WHERE owner_client_id IS NOT NULL AND group_key IS NOT NULL;

CREATE UNIQUE INDEX ux_events_by_keys_no_client ON reminders.events(group_key, event_key)
    WHERE owner_client_id IS NULL AND group_key IS NOT NULL;


CREATE TABLE reminders.buckets (
    bucket_id  integer not null PRIMARY KEY,
    hostname   text,
    heartbeat  timestamptz
);

ALTER TABLE reminders.events
    ADD CONSTRAINT fk_events_to_buckets
    FOREIGN KEY (bucket_id)
    REFERENCES reminders.buckets(bucket_id)
    ON DELETE RESTRICT;

