CREATE TYPE reminders.change_type AS ENUM (
  'delete'
);


CREATE TABLE reminders.change_log (
  cid bigserial primary key,
  at timestamptz default now(),
  event_id bigint,
  owner_client_id bigint,
  event_key  text,
  group_key  text,
  change_type reminders.change_type,
  event_data reminders.events,
  change_info jsonb
);

CREATE INDEX i_change_log_by_event_id ON reminders.change_log (event_id);
CREATE INDEX i_change_log_by_external_keys ON reminders.change_log (owner_client_id, group_key, event_key);
CREATE INDEX i_change_log_by_group_key ON reminders.change_log (owner_client_id, group_key, at);