CREATE TABLE reminders.schedules (
    schedule_id     bigserial primary key,
    owner_client_id bigint,
    is_active       boolean default true,
    crontab         text not null,
    -- Payload
    context jsonb not null,
    cb_url  text not null
);

CREATE INDEX i_schedules_by_owner_client_id ON reminders.schedules (owner_client_id, schedule_id) WHERE owner_client_id IS NOT NULL;
CREATE INDEX i_schedules_with_null_owner_client_id ON reminders.schedules (schedule_id) WHERE owner_client_id IS NULL;

CREATE TABLE reminders.scheduled_events (
    -- Owner_client_id for records locality @ indexes
    owner_client_id    bigint,
    run_at timestamptz not null,
    schedule_id bigint not null,
    event_id bigint    not null
);

CREATE UNIQUE INDEX ux_scheduled_events ON reminders.scheduled_events (owner_client_id, schedule_id, run_at) WHERE owner_client_id IS NOT NULL;
CREATE UNIQUE INDEX ux_scheduled_events_with_null_owner_client_id ON reminders.scheduled_events (schedule_id, run_at) WHERE owner_client_id IS NULL;
