CREATE UNIQUE INDEX CONCURRENTLY ux_events_by_keys_new ON reminders.events(COALESCE(owner_client_id, -1), group_key, event_key)
    WHERE group_key IS NOT NULL;

CREATE INDEX CONCURRENTLY i_schedules_by_owner_client_id_new ON reminders.schedules (COALESCE(owner_client_id, -1), schedule_id);

CREATE UNIQUE INDEX CONCURRENTLY ux_scheduled_events_new ON reminders.scheduled_events (COALESCE(owner_client_id, -1), schedule_id, run_at);
CREATE UNIQUE INDEX CONCURRENTLY ux_scheduled_events_event_id ON reminders.scheduled_events (event_id);

ALTER TABLE reminders.scheduled_events
    ADD CONSTRAINT fk_scheduled_events_to_events
    FOREIGN KEY (event_id)
    REFERENCES reminders.events
    ON DELETE CASCADE;
