#include <boost/python/suite/indexing/vector_indexing_suite.hpp>
#include <boost/python.hpp>

#include <mail/catdog/address_parser/lib/address_parser.h>


BOOST_PYTHON_MODULE(address_parser) {
    using namespace boost::python;

    class_<address_parser::Recipient>("Recipient", no_init)
            .def_readwrite("display_name", &address_parser::Recipient::display_name)
            .def_readwrite("domain", &address_parser::Recipient::domain)
            .def_readwrite("local", &address_parser::Recipient::local)
            .def_readwrite("email", &address_parser::Recipient::email)
            .def_readwrite("valid", &address_parser::Recipient::valid)
            .def(self_ns::str(self_ns::self))
    ;

    class_<std::vector<address_parser::Recipient>>("Recipients")
        .def(vector_indexing_suite<std::vector<address_parser::Recipient>>())
    ;

    def("parse_recipients", address_parser::parseRecipients);
}
