# cython: c_string_type=str, c_string_encoding=utf-8

from libcpp.string cimport string
from libcpp.vector cimport vector
from libcpp.string cimport string
from libcpp.vector cimport vector
from libcpp cimport bool


cdef extern from "mail/catdog/address_parser/lib/address_parser.h" namespace "address_parser":
    cdef cppclass RawRecipient:
        string display_name, domain, local, email
        bool valid

    vector[RawRecipient] parseRecipients(string&) except +
    string toString(RawRecipient&) except +


cdef class Recipient:
    cdef RawRecipient* rec

    def __cinit__(self):
        self.rec = new RawRecipient()

    def __dealloc__(self):
        del self.rec

    @staticmethod
    cdef create(const RawRecipient& r):
        cdef Recipient ret = Recipient()
        ret.rec.display_name = r.display_name
        ret.rec.domain = r.domain
        ret.rec.local = r.local
        ret.rec.email = r.email
        ret.rec.valid = r.valid

        return ret

    def __str__(self):
        return to_py_string(toString(self.rec[0]))

    property display_name:
        def __get__(self): return self.rec.display_name

    property domain:
        def __get__(self): return self.rec.domain

    property local:
        def __get__(self): return self.rec.local

    property email:
        def __get__(self): return self.rec.email

    property valid:
        def __get__(self): return self.rec.valid


cdef str to_py_string(const string& s) except +:
    return s.c_str()[:s.size()]


cdef string to_cpp_string(s) except +:
    return s.encode('utf-8')


def parse_recipients(rec):
    return [Recipient.create(i) for i in parseRecipients(to_cpp_string(rec))]

