#pragma once

#include <ostream>
#include <vector>
#include <memory>
#include <string>


namespace address_parser {

struct Recipient {
    std::string display_name;
    std::string local;
    std::string domain;
    std::string email;
    bool valid;
};

using Recipients = std::vector<Recipient>;
using RawRecipient = Recipient;

std::string toString(const Recipient& r);
Recipients parseRecipients(const std::string& recipients);
std::ostream& operator<<(std::ostream& out, const Recipient& r);
bool operator==(const Recipient& r1, const Recipient& r2);

}
