# CATDOG
 Сервис **catdog** отвечает за валидацию email-адресов и формирование ссылок на аватарки.

## HTTP API
* **/ping** - pong (тест доступности сервиса)
* **/emails** - валидация адресов и формирование ссылок на аватарки
ручка в теле POST получает json массив строк, возвращает json-массив объектов

## Архитектура
* qloud: https://platform.yandex-team.ru/projects/mail/catdog

| группа                          | суффикс        | число узлов |
| :-----------------------------  | :------------  | ----------: |
| mail_catdog_production          |                |      **85** |
|                                 | _catdog        |          82 |
|                                 | _catdog-canary |           3 |
| mail_catdig_intranet-production |                |       **11**|
|                                 | _catdog        |          10 |
|                                 | _catdog-canary |           1 |

\* Число узлов по состоянию на август 2019


#### Структура контейнера

Сервис **catdog** живёт в отдельном контейнере, в котором запущено всего 2 воркера на портах **2017** и **2018**. Кроме самого сервиса в контейнере располагаются другие вспомогательные сервисы: **nginx** (проксирует запросы извне, ограничивает rps, балансирует нагрузку least_conn), **supervisord** (следит за процессом сервиса, перезапускает сервисы). Ручка **/stat** реализована в самом сервисе, unistat-демона в контейнере нет

#### Цикл работы

* Потребитель приходит в сервис массивом строк, в которых предположительно email-ы
* Сервис парсит адреса с помощью плюсовой библиотеки парсинга email-ов
* Каждый адрес попадает в какую-то из категорий:
- Yandex - 47% - яндексовые пользователи и pdd-домены
- Ava - 17% - gmail/mail.ru
- Organizations - 13% - разные не очень большие рассыльщики, для которых показывается специальная цветная аватарка
- Staff (только для intranet) - аккаунт на стафе
- Yasrv - ~1% - адреса яндексовых сервисов (taxi.yandex.ru)
- Top200 - 7% - сторонние рассыльщики, для которых сделали отдельную аватарку (avito.ru)
- Yahoo - ~1% - домены yahoo
- Other - 13% - остальные адреса
- Invalid - ~1% - невалидные адреса
* Если адрес относится к категории **Yandex**, то **catdog** идёт в **blackbox** за информацией о пользователе
* Если адрес относится к категории **Ava**, то **catdog** идёт в **ava** за ссылкой на аватарку
* Иначе аватарка генерируется из адреса и информации из локальных файлов
* Потребителю отдается сформированный ответ с информацией о валидности email-а и аватаркой для него


## Logs

* **nginx**:
    * **access** (/var/log/nginx/akita/access.tskv)
* **catdog**:
    * **catdog** (/var/log/catdog/catdog.log-20(17|18)
* **прочие**:
    * supervisord (/var/log/supervisor/supervisord.log)

#### Что в логах
* в *nginx* *access* регистрируются поступившие в proxy-сервис запросы и статусы их выполнения (или отклонения, если например превышен рейт).
* в *catdog* пишется всё остальное: какие запросы пришли, куда сходили по http, что ответили пользователю (только в debug режиме)


## Dashboards
* [production](https://yasm.yandex-team.ru/template/panel/mail_catdog_template/prj=mail.catdog.production/)
* [corp](https://yasm.yandex-team.ru/template/panel/mail_catdog_template/prj=mail.catdog.intranet-production/)


![График распределения запросов за сутки по кластеру]( https://yasm.yandex-team.ru/img/5b47ed899ffb6b2db3c5f864a8403c23.png 
)

Для примера взят график входящих запросов за 19 августа 2019 года:

* min число запросов в секунду: ~470
* max число запросов в секунду: ~11.5 тыс
* max число запросов в секунду для одного узла: около 150рпс в пике
* один инстанс держит около 280 рпс

Для каждой машины на продакшене в nginx'е установлен лимит в 250 rps и burst 20


