from mail.catdog.catdog.src import logger


class Context:
    x_req_id = ''
    ip = ''
    check_warn = False
    uid = None

    def __init__(self, req, check_warn=False):
        if 'X-Request-Id' in req.headers:
            self.x_req_id = req.headers['X-Request-Id']
        if 'X-Real-Ip' in req.headers:
            self.ip = req.headers['X-Real-Ip']
        else:
            peername = req.transport.get_extra_info('peername')
            if peername is not None:
                self.ip = peername[0]

        self.check_warn = check_warn
        self.uid = req.query['uid'] if 'uid' in req.query else None

    def log_error(self, reason, message, **kwargs):
        logger.log(level='error', reason=reason, message=message, x_request_id=self.x_req_id, **kwargs)

    def log_warning(self, reason, message, **kwargs):
        logger.log(level='warning', reason=reason, message=message, x_request_id=self.x_req_id, **kwargs)

    def log_info(self, reason, message, **kwargs):
        logger.log(level='info', reason=reason, message=message, x_request_id=self.x_req_id, **kwargs)

    def log_debug(self, reason, message, **kwargs):
        logger.log(level='debug', reason=reason, message=message, x_request_id=self.x_req_id, **kwargs)
