#!/usr/bin/env python3

import sys
import subprocess
import json
import tempfile
from PIL import Image


colors = {
    'red': '\033[0;31m',
    'green': '\033[0;32m',
    'end': '\033[m'
}


def bash(cmd):
    print('{green}{cmd}{end}'.format(cmd=cmd, **colors), file=sys.stderr)
    proc = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
    proc.wait()
    if proc.returncode != 0:
        raise Exception('curl status is ' + str(proc.returncode))

    return ''.join([line.decode('utf-8') for line in proc.stdout.readlines()])


def main(domains_name):
    domain_with_color = {}
    tmp_file = tempfile.NamedTemporaryFile(delete=False).name
    with open(domains_name) as domains:
        for line in domains.readlines():
            domain = line.strip()
            bash('curl -s -m10 --retry 5 -o {file} "http://favicon.yandex.net/favicon/{domain}?size=32"'
                 .format(domain=domain, file=tmp_file))

            image = Image.open(tmp_file)

            if image.size == (32, 32):
                color_resp = bash('curl -s -m10 --retry 5 --data-binary @{file} '.format(file=tmp_file) +
                                  '"http://yavision.yandex.net/imageparser/http_parse?CalcMainColor"')

                try:
                    js = json.loads(color_resp)
                except:
                    domain_with_color[domain] = None
                else:
                    domain_with_color[domain] = js['MainColor'] if js['MainColor'] != '' and js['MainColor'] != '#F8F8F8' else js['SecondColor']
            else:
                domain_with_color[domain] = None

    with open('organizations.json', 'w') as out:
        json.dump(domain_with_color, out, indent=4, sort_keys=True)


if __name__ == '__main__':
    if len(sys.argv) != 2:
        print(print('{red}Usage: prog <file_with_domains>{end}'.format(**colors), file=sys.stderr))
    else:
        main(sys.argv[1])
