#!/bin/bash

set -xe

app=catdog

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /ephemeral ]]; then
        mkdir -p /ephemeral/var/log/
        rsync -av /var/log/ /ephemeral/var/log/

        rm -rf /var/log

        ln -sf /ephemeral/var/log /var/log

        break
    else
        echo "Ephemeral not found, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to link ephemeral, cannot start"
    exit 1
fi


if [[ -d /secrets/ssl ]]; then
    echo "copying crt"
    rsync -av /secrets/ssl/ /etc/nginx/ssl/

    if [[ "$?" != 0 ]]; then
        >&2 echo "Can't copy certificates"
        exit 1
    fi

    echo "Certificates ok"
else
    >&2 echo "No certificates found, cannot start"
    exit 1
fi


if [[ "${ENVIRONMENT_TYPE}" ]]; then
    if [[ "${ENVIRONMENT_NAME}" ]]; then
        ENVIRONMENT="${ENVIRONMENT_NAME}-${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_NAME" > /etc/yandex/environment.name
    else
        ENVIRONMENT="${ENVIRONMENT_TYPE}"
        echo "$ENVIRONMENT_TYPE" > /etc/yandex/environment.type
    fi
else
    echo "ENVIRONMENT_TYPE not set, cannot start"
    exit 1
fi


case "$ENVIRONMENT" in
    production|prestable)
        yav get version sec-01drgn5a7qcg942dz54gdja0bm -o client_secret > /etc/catdog/tvm_secret
        ;;
    intranet-production|intranet-prestable)
        yav get version sec-01drgn60n05b3kydstbed16pf3 -o client_secret > /etc/catdog/tvm_secret
        ;;
    testing|load)
        yav get version sec-01drgna6nv289nttmapaqhm9kk -o client_secret > /etc/catdog/tvm_secret
        ;;
    *)
        echo "Cannot get tvm_secret for environment $ENVIRONMENT"
        exit 1
        ;;
esac


aws configure set aws_access_key_id     `yav get version sec-01d34s477p8fak79sq374swfqa -o s3.service936.AccessKeyId    ` --profile pdd-domains
aws configure set aws_secret_access_key `yav get version sec-01d34s477p8fak79sq374swfqa -o s3.service936.AccessSecretKey` --profile pdd-domains

aws configure set aws_access_key_id     `yav get version sec-01d34s477p8fak79sq374swfqa -o s3.service4456.AccessKeyId    ` --profile avatars
aws configure set aws_secret_access_key `yav get version sec-01d34s477p8fak79sq374swfqa -o s3.service4456.AccessSecretKey` --profile avatars


for i in {1..10}; do
    if /usr/bin/pdd-domains-update.sh now ; then
        break
    else
        echo "Failed to get pdd-domains from s3, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Failed to get pdd-domains from s3, cannot start"
    exit 1
fi


ln -sf /usr/share/catdog/catdog.md /usr/share/catdog/about
