import yaml
from mail.catdog.catdog.src.icon import IconTraits


class Config(dict):
    __getattr__ = dict.get
    __setattr__ = dict.__setitem__
    __delattr__ = dict.__delitem__


def init_config(path, env_name, env_type):
    if env_type is None:
        raise Exception('env_type must be set')

    env = env_name + '-' + env_type if env_name else env_type

    if env not in ['production', 'intranet-production', 'testing', 'development',
                   'prestable', 'intranet-prestable', 'stress']:
        raise Exception('cannot get config for environment name: "{0}" type: "{1}"'.format(env_name, env_type))

    with open(path) as f:
        c = yaml.full_load(f)

    temp = Config({**c['common'], **c['variables'][env]})
    temp.timeout = Config({**temp.timeout})
    temp.tvm2 = Config({**c['common']['tvm2'], **c['variables'][env]['tvm2']})
    temp.tvm2.destinations = Config({**c['common']['tvm2']['destinations'],
                                     **c['variables'][env]['tvm2']['destinations']})
    temp.s3 = Config({**c['common']['s3'], **c['variables'][env]['s3']})
    temp.env = env

    return temp


def init(path, env_name, env_type):
    global instance
    instance = init_config(path, env_name, env_type)
    instance.icon_traits = IconTraits(instance.mobile_link_template)


instance = Config()


def cfg():
    return instance
