from aiohttp import ClientSession as CS
from async_timeout import timeout
from mail.catdog.catdog.src.config import cfg
import asyncio
import time

from mail.catdog.catdog.src.tvm import get_service_ticket


class HttpException(Exception):
    pass


session = None


async def set_session():
    global session
    session = CS(loop=asyncio.get_event_loop(),
                 read_timeout=cfg().http_timeout,
                 conn_timeout=cfg().http_conn_timeout)


class Client:
    async def fetch(self, method, dst, ctx, **kwargs):
        dst_str = str(dst).replace('Destination.', '')
        ctx.log_info(reason='http', message='start', dst=dst_str, url=kwargs['url'])
        now = time.time()
        try:
            ticket = get_service_ticket(dst)
            headers = {}
            if ticket is not None:
                headers['X-Ya-Service-Ticket'] = ticket

            async with timeout(cfg().http_timeout) as tout:
                async with method(session, **kwargs, headers=headers) as resp:
                    if resp.status != 200:
                        ctx.log_error(reason='http', message='bad code', dst=dst_str, url=kwargs['url'],
                                      code=resp.status, time='{:1.6f}'.format(time.time() - now))
                        raise HttpException(str(resp.status))
                    result = await resp.text()
                    ctx.log_info(reason='http', message='finished', dst=dst_str, url=kwargs['url'],
                                 size=len(result), time='{:1.6f}'.format(time.time() - now))
                    return result
                if tout.expired:
                    raise HttpException(str('async_timeout '+dst_str))
        except Exception as e:
            msg = str(e)
            if len(msg) == 0:
                msg = e.__class__.__name__
            ctx.log_error(reason='http', message='exception', dst=dst_str, url=kwargs['url'],
                          exception=msg, time='{:1.6f}'.format(time.time() - now))
            raise HttpException(e)

    async def get(self, dst, ctx, url):
        return await self.fetch(CS.get, dst=dst, ctx=ctx, url=url)

    async def post(self, dst, ctx, url, body):
        return await self.fetch(CS.post, dst=dst, ctx=ctx, url=url, data=body)
