from collections import Counter
from operator import itemgetter


class LogStats:
    graphics = {
        'codes': {
            'suffix': 'summ',
            'signals': Counter(dict.fromkeys([
                'req', '2xx', '4xx', '5xx',
            ], 0))
        },
        'time': {
            'suffix': 'hgram',
            'signals': Counter(dict.fromkeys([
                0, 20, 50, 100, 150, 200, 1000,
            ], 0))
        },
        'errors': {
            'suffix': 'summ',
            'signals': Counter(dict.fromkeys([
                'ava_http_error', 'ava_parse_error', 'bb_http_error', 'bb_parse_error',
            ], 0))
        },
        'http_reqs': {
            'suffix': 'summ',
            'signals': Counter(dict.fromkeys([
                'bb_reqs', 'ava_reqs',
            ], 0))
        },
        'http_client_bb': {
            'suffix': 'hgram',
            'signals': Counter(dict.fromkeys([
                0, 20, 50, 100, 150, 200, 1000,
            ], 0))
        },
        'http_client_ava': {
            'suffix': 'hgram',
            'signals': Counter(dict.fromkeys([
                0, 20, 50, 100, 150, 200, 1000,
            ], 0))
        }
    }

    @staticmethod
    def _make_summ_signal(name, signals):
        return [
            ('{0}_{1}_summ'.format(name, k), v)
            for k, v in signals.items()
        ]

    @staticmethod
    def _make_hgram_signal(name, signals):
        buckets = [[k, v] for k, v in signals.items()]
        buckets.append([max(buckets, key=itemgetter(0))[0] * 2, 0])
        return [(
            '{0}_hgram'.format(name),
            sorted(buckets)
        )]

    @staticmethod
    def _parse_time(time, stat):
        buckets = sorted(stat.keys())
        for i in range(len(buckets) - 1):
            if buckets[i] <= time < buckets[i + 1]:
                stat[buckets[i]] += 1
                return
        stat[buckets[-1]] += 1

    def parse_line(self, **data):
        if 'reason' not in data or 'message' not in data:
            pass

        reason = data['reason']
        message = data['message']

        if reason == 'handle_emails' and message == 'accept':
            self.graphics['codes']['signals']['req'] += 1
        if reason == 'handle_emails' and message == 'done' and 'status' in data:
            status = int(data['status']) / 100
            if status == 2:
                self.graphics['codes']['signals']['2xx'] += 1
            elif status == 4:
                self.graphics['codes']['signals']['4xx'] += 1
            elif status == 5:
                self.graphics['codes']['signals']['5xx'] += 1

        if reason == 'ava' and message == 'ava http error':
            self.graphics['errors']['signals']['ava_http_error'] += 1
        if reason == 'ava' and message == 'ava parse error':
            self.graphics['errors']['signals']['ava_parse_error'] += 1
        if reason == 'yandex' and message == 'bb http error':
            self.graphics['errors']['signals']['bb_http_error'] += 1
        if reason == 'yandex' and message == 'bb parse error':
            self.graphics['errors']['signals']['bb_parse_error'] += 1

        if reason == 'handle_emails' and message == 'done' and 'time' in data:
            try:
                time = float(data['time']) * 1000
                self._parse_time(time, self.graphics['time']['signals'])
            except:
                pass

        if reason == 'http' and 'time' in data:
            try:
                time = float(data['time']) * 1000
                dst = data['dst'] if 'dst' in data else ''
                if dst == 'bb':
                    self.graphics['http_reqs']['signals']['bb_reqs'] += 1
                if dst == 'ava':
                    self.graphics['http_reqs']['signals']['ava_reqs'] += 1
                self._parse_time(time, self.graphics['http_client_' + dst]['signals'])
            except:
                pass

    def golovan(self, tier):
        result = []
        for name, val in self.graphics.items():
            if val['suffix'] == 'summ':
                result += self._make_summ_signal(tier+';'+name, val['signals'])
            if val['suffix'] == 'hgram':
                result += self._make_hgram_signal(tier+';'+name, val['signals'])
        return result
