from mail.catdog.catdog.src import mono
from mail.catdog.catdog.src.organizations import Organizations
from mail.catdog.catdog.src.staff import Staff
from mail.catdog.catdog.src import stat
from mail.catdog.catdog.src.top200 import Top200
from mail.catdog.catdog.src.yahoo import Yahoo
from mail.catdog.catdog.src.yandex import Yandex
from mail.catdog.catdog.src.yasrv import Yasrv


class Other(object):
    name = 'none'
    stat = 'other'
    ava = mono.type2

    def process(self, email, ctx):
        return Other.ava(email, ctx)

    def check(self, email):
        return True


def choose_handlers(email, ctx):
    handlers = [Staff(), Yasrv(), Top200(), Yandex(),
                Organizations(), Yahoo(), Other()]

    handler = next(filter(lambda h: h.check(email), handlers))

    ctx.log_debug(reason='logic', message=handler.name, email=email.email)
    stat.instance.increase(handler.stat)

    return handler
