import hashlib

from cpp import isYandexEmail, getKey, hasOrganizationColor, mapOfOrganizationsColors, getOrganizationColor, getPalette
from mail.catdog.catdog.src.data.top200 import map_of_top_senders_icons


def colorhash(emailstring):
    hash = hashlib.md5(emailstring.encode('utf-8')).digest()
    palette = list(getPalette())
    return palette[hash[0] % len(palette)]


def get_color(email):
    if hasOrganizationColor(email.domain):
        return getOrganizationColor(email.domain)
    return colorhash(email.domain)


def filter_symbols(string):
    return ''.join(c for c in string if str.isalnum(c))


def get_domain(email):
    res = getKey(email, map_of_top_senders_icons)
    if res is None:
        res = getKey(email, mapOfOrganizationsColors())
        if res is None:
            res = email.domain
    return res


def type1(email, ctx):
    dn = filter_symbols(email.display_name.strip())
    if len(dn) > 0:
        char = dn[0]
    else:
        char = get_domain(email)[0]
    email.mono = char.upper()
    email.color = get_color(email)
    ctx.log_debug(reason='mono', message='type1', email=email.email, mono=email.mono, color=email.color)
    return email


def filter_words(lst):
    lst2 = [filter_symbols(s) for s in lst]
    return [s for s in lst2 if len(s)]


def get_key_to_hash(email):
    if isYandexEmail(email.domain):
        return email.local.replace('.', '-')
    return email.local + email.domain


def type2(email, ctx):
    if email.display_name.strip('"') == '{}@{}'.format(email.local, email.domain):
        display_name = ''
    else:
        display_name = email.display_name.replace('.', ' ')
    words = filter_words(display_name.split())
    if len(words) > 1:
        chars = words[0][0] + words[1][0]
    elif len(words) == 1:
        if len(words[0]) > 1:
            chars = words[0][0] + words[0][1]
        else:
            chars = words[0][0]
    else:
        local_filtered = filter_symbols(email.local)
        if len(local_filtered) > 1:
            chars = local_filtered[0] + local_filtered[1]
        else:
            chars = local_filtered[0]
    email.mono = chars.upper()
    email.color = colorhash(get_key_to_hash(email))
    ctx.log_debug(reason='mono', message='type2', email=email.email, mono=email.mono, color=email.color)
    return email
