import address_parser
from cpp import is_warning
from mail.catdog.catdog.src.reflect import reflect_as_dict


class RecipientAddress(object):
    def __init__(self, display_name='', domain='', local='', email='', valid=None):
        self.valid = valid
        self.display_name = display_name
        self.domain = domain
        self.local = local
        self.email = email


class Recipient(object):
    def __init__(self, recipient_address, ctx):
        self.valid = True if recipient_address.valid is None else recipient_address.valid
        self.display_name = recipient_address.display_name if self.valid else None
        self.domain = recipient_address.domain if self.valid else None
        self.local = recipient_address.local.split('+')[0] if self.valid else None
        self.email = recipient_address.email
        self.ava = None
        self.warn = is_warning(recipient_address, ctx)
        self.is_self = False

    def as_dict(self):
        return reflect_as_dict(self)

    def set_ava(self, obj):
        self.ava = obj


def parse_email(string, ctx):
    return map(lambda r: Recipient(r, ctx), address_parser.parse_recipients(string))
