import boto3
import json


class S3(object):
    def __init__(self, config):
        self._folder = config.folder
        self._bucket = boto3.Session(profile_name=config.profile).resource('s3',
                                                                           endpoint_url=config.endpoint,
                                                                           verify=config.verify).Bucket(config.bucket)

    def load_dictionary(self, name):
        raw = self._bucket.Object('{}/{}'.format(self._folder, name)).get()['Body'].read()
        return json.loads(raw.decode('utf-8'))
