import json

from mail.catdog.catdog.src import mono, yasrv
from mail.catdog.catdog.src.config import cfg
from mail.catdog.catdog.src.data.ytsrv import map_of_yandex_team_services
from cpp import Destination, Avatar
from mail.catdog.catdog.src.http_client import Client
from mail.catdog.catdog.src.icon import Icon
from mail.catdog.catdog.src.data.yasrv import map_of_yandex_services_icons_by_email


yandex_team_services = map_of_yandex_team_services


def is_running_on_corp():
    return cfg().use_staff


def is_yamoney(email):
    return email.domain == 'yamoney.ru'


def is_yandex_team(email):
    raw_email = email.local + '@' + email.domain

    return (email.domain in [
        'yandex-team.ru',
        'yandex-team.com',
        'yandex-team.com.tr',
        'yandex-team.com.ua',
        'k50.ru',
        'openyard.ru',
        'ext.yandex.ru'
    ] or raw_email in yandex_team_services) and raw_email not in map_of_yandex_services_icons_by_email


def normalize_staff_login(login):
    return login.replace('.', '-')


def do(email, ctx):
    e = email.local + '@' + email.domain
    if e in yandex_team_services:
        icon = Icon(yandex_team_services[e], cfg().icon_traits)
        email.set_ava(icon)
        ctx.log_debug(reason='staff', message='icon', email=email.email, icon=icon)
    else:
        login = normalize_staff_login(email.local)
        link_template = 'http://center-api.yandex-team.ru/api/v1/user/{0}/avatar/{1}.jpg'
        avatar = Avatar(url=link_template.format(login, cfg().staff_avatar_size),
                        url_small=link_template.format(login, cfg().staff_avatar_size_ie))
        email.set_ava(avatar)
        ctx.log_debug(reason='staff', message='link', email=email.email, normalized_local=login)
    return email


async def check_if_user_exists(email, ctx, url):
    client = Client()
    ctx.log_info(reason='yamoney', message='resolving', email=email.email)
    try:
        url = '{0}/blackbox?method=userinfo&login={1}%40{2}&userip={3}&regname=yes&format=json'.format(url, email.local,
                                                                                                       'yandex-team.ru',
                                                                                                       ctx.ip)

        http = await client.get(dst=Destination.bb_corp, ctx=ctx, url=url)
        return 'value' in json.loads(http)['users'][0]['uid']
    except Exception:
        return False


def load(s3):
    global yandex_team_services
    yandex_team_services = s3.load_dictionary('yandex_team.json')


class Staff(object):
    name = 'staff'
    stat = 'staff'
    ava = mono.type2

    async def process(self, email, ctx):
        if is_yamoney(email=email):
            if not await check_if_user_exists(email=email, ctx=ctx, url=cfg().blackbox_corp_url):
                return yasrv.Yasrv().process(email=email, ctx=ctx)

        return Staff.ava(do(email, ctx), ctx)

    def check(self, email):
        return is_running_on_corp() and (is_yandex_team(email) or is_yamoney(email))
