from mail.catdog.catdog.src.log_stat import LogStats


class Stat:
    def __init__(self, tier):
        self.log_stats = LogStats()
        self._names = ['staff', 'yasrv', 'top200', 'yandex', 'grm', 'org', 'yahoo', 'other', 'invalid']
        self._stats = {stat: 0 for stat in self._names}
        self.tier = 'tier='+tier

    def increase(self, key):
        self._stats[key] += 1

    def dict(self):
        lst = self.log_stats.golovan(self.tier) + [(self.tier+';'+name+'_summ', self._stats[name]) for name in self._names]
        return {k: v for k, v in lst}


instance = Stat('')
