from mail.catdog.catdog.src.data.top200 import map_of_top_senders_icons
from mail.catdog.catdog.src import mono
from cpp import getKey
from mail.catdog.catdog.src.icon import Icon
from mail.catdog.catdog.src.config import cfg


top200 = map_of_top_senders_icons


def is_top(email):
    return getKey(email, top200) is not None


def do(email, ctx):
    key = getKey(email, top200)
    icon = Icon(top200[key], cfg().icon_traits)
    email.set_ava(icon)
    ctx.log_debug(reason='top200', message='icon', email=email.email, icon=icon)
    return email


def load(s3):
    global top200
    top200 = s3.load_dictionary('services.json')


class Top200(object):
    name = 'top200'
    stat = 'top200'
    ava = mono.type1

    def process(self, email, ctx):
        return Top200.ava(do(email, ctx), ctx)

    def check(self, email):
        return is_top(email)
