from tvm2 import TVM2
from ticket_parser2.api.v1 import BlackboxClientId
from cpp import makeDestinationByName

instance = None
dst_to_id = {}


def _env_to_bbenv(env):
    if 'intranet' in env:
        return BlackboxClientId.ProdYateam
    elif env == 'production' or env == 'prestable':
        return BlackboxClientId.Prod
    else:
        return BlackboxClientId.Test


def init(config, env):
    global instance, dst_to_id

    for dest_name, id in config['destinations'].items():
        dst_to_id[makeDestinationByName(dest_name)] = id

    with open(config['path_to_secret']) as f:
        secret = f.readline()

    instance = TVM2(client_id=config['client_id'], secret=secret, blackbox_client=_env_to_bbenv(env),
                    destinations={v for k, v in config['destinations'].items()})


def get_service_ticket(destination):
    if destination not in dst_to_id:
        return None
    dest = dst_to_id[destination]
    return instance.get_service_tickets(dest).get(dest)
