from mail.catdog.catdog.src import mono


def is_mailing_system(email):
    return email.domain in [
        'yahoo.com',
        'ymail.com',  # org
        'rocketmail.com',  # org
        'hotmail.com',
        'live.com',  # org
        'msn.com',  # org
        'aol.com',  # org
        'km.ru',  # org
        'freemail.ru',
        'bossmail.ru',
        'girlmail.ru',
        'boymail.ru',
        'safebox.ru',
        'megabox.ru',
        'mail.com',
        'qip.ru',  # org
        'pochta.ru',  # org
        'hotbox.ru',  # org
        'hotmail.ru',  # org
        'krovatka.su',
        'land.ru',  # org
        'newmail.ru',  # org
        'nm.ru',  # org
        'pisem.net',  # org
        'pop3.ru',
        'rbcmail.ru',
        'smtp.ru',
        '5ballov.ru',
        'ziza.ru',
        'outlook.com',
        'outlook.fr',
        'pochta.com'
    ]


class Yahoo(object):
    name = 'yahoo'
    stat = 'yahoo'
    ava = mono.type2

    def process(self, email, ctx):
        return Yahoo.ava(email, ctx)

    def check(self, email):
        return is_mailing_system(email)
