from mail.catdog.catdog.src import mono
from cpp import Destination, Avatar
from mail.catdog.catdog.src.http_client import Client, HttpException
from mail.catdog.catdog.src.config import cfg
import json
from cpp import isYandexEmail


async def call_bb(email, ctx):
    client = Client()
    ctx.log_info(reason='yandex', message='resolving', email=email.email)
    try:
        http = await client.get(
            Destination.bb,
            ctx,
            f'{cfg().blackbox_url}/blackbox?method=userinfo&login={email.local}%40{email.domain}&userip={ctx.ip}&regname=yes&format=json')
    except HttpException:
        ctx.log_error(reason='yandex', message='bb http error', email=email.email)
        return None, True, False

    return parse_blackbox(http, ctx)


def do(email, ctx, bb_response):
    ava_id, email.warn, email.is_self = bb_response
    if ava_id is None:
        ctx.log_debug(reason='yandex', message='bb parse got no avatar', email=email.email)
        return email
    else:
        ctx.log_debug(reason='yandex', message='link', email=email.email, ava_id=ava_id)
        avatar = Avatar(cfg().yandex_avatar_mask.format(ava_id, cfg().yandex_avatar_size),
                        cfg().yandex_avatar_mask.format(ava_id, cfg().yandex_avatar_size_ie))
        email.set_ava(avatar)
        return email


def parse_blackbox(resp, ctx):
    try:
        obj = json.loads(resp)
        if 'users' not in obj:
            ctx.log_error(reason='yandex', message='bb parse error', details='no users in response')
            return None, False, False
        if len(obj['users']) != 1:
            ctx.log_error(reason='yandex', message='bb parse error', details='empty users array')
            return None, False, False
        user = obj['users'][0]
        if 'display_name' not in user \
                or 'avatar' not in user['display_name'] \
                or 'empty' not in user['display_name']['avatar'] \
                or 'default' not in user['display_name']['avatar']:
            ctx.log_error(reason='yandex', message='bb parse error', details='lack of fields')
            return None, ctx.check_warn, False
        warn = check_warn(ctx.check_warn, user)
        is_self = check_is_self(ctx.uid, user)
        if user['display_name']['avatar']['empty']:
            ctx.log_debug(reason='yandex', message='bb parse error', details='avatar is not set')
            return None, warn, is_self
        return user['display_name']['avatar']['default'], warn, is_self
    except (json.JSONDecodeError, TypeError):
        ctx.log_error(reason='yandex', message='bb parse error', details='json decode error')
        return None, False, False


def check_warn(do_check, data):
    if not do_check:
        return False
    if 'karma' not in data or 'value' not in data['karma']:
        return False
    karma = data['karma']['value']
    return karma == 100


def check_is_self(uid, data):
    if uid is None:
        return False
    if 'uid' not in data or 'value' not in data['uid']:
        return False
    passport_uid = data['uid']['value']
    return uid == passport_uid


class Yandex(object):
    name = 'yandex'
    stat = 'yandex'
    ava = mono.type2

    async def process(self, email, ctx):
        res = await call_bb(email, ctx)
        return Yandex.ava(do(email=email, ctx=ctx, bb_response=res), ctx)

    def check(self, email):
        return isYandexEmail(email.domain)
