from mail.catdog.catdog.src.data.yasrv import map_of_yandex_services_icons_by_domain, map_of_yandex_services_icons_by_email
from mail.catdog.catdog.src import mono
from mail.catdog.catdog.src.icon import Icon
from mail.catdog.catdog.src.config import cfg
from cpp import getListofYandexDomains

yandex_services = {
    'by_domain': map_of_yandex_services_icons_by_domain,
    'by_email': map_of_yandex_services_icons_by_email
}


def get_normalized_domain(email):
    domain_normalized = email.domain
    domain_subdomains = email.domain.split('.')
    for ya_domain in list(getListofYandexDomains()):
        ya_subdomains = ya_domain.split('.')
        if domain_subdomains[-len(ya_subdomains):] == ya_subdomains:
            joined = '.'.join(domain_subdomains[:-len(ya_subdomains)])
            domain_normalized = joined + '.Y' if len(joined) > 0 else 'Y'
    return domain_normalized


def is_yasrv(email):
    domain_normalized = get_normalized_domain(email)
    return email.local + '@' + domain_normalized in yandex_services['by_email'] or \
           domain_normalized in yandex_services['by_domain']


def do(email, ctx):
    domain_normalized = get_normalized_domain(email)
    e = email.local + '@' + domain_normalized
    if e in yandex_services['by_email']:
        icon_name = yandex_services['by_email'][e]
    else:
        icon_name = yandex_services['by_domain'][domain_normalized]
    icon = Icon(icon_name, cfg().icon_traits)
    email.set_ava(icon)
    return email


def load(s3):
    yandex_services['by_domain'] = s3.load_dictionary('yandex_domains.json')
    yandex_services['by_email'] = s3.load_dictionary('yandex_addresses.json')


class Yasrv(object):
    name = 'yasrv'
    stat = 'yasrv'
    ava = mono.type1

    def process(self, email, ctx):
        icon = Yasrv.ava(do(email, ctx), ctx)
        ctx.log_debug(reason='yasrv', message='icon', email=email.email, icon=icon.ava.name)
        return icon

    def check(self, email):
        return is_yasrv(email)
