#!/usr/bin/env bash


case "$1" in 
    "prod")
        ASK_TEST=false
        ASK_PROD=false
    ;;
    "test")
        ASK_TEST=false
        ASK_PROD=true
    ;;
    *)
        ASK_TEST=true
        ASK_PROD=true
    ;;
esac

function refresh {
    executer ''
}

function run {
    executer -c "p_exec $1 curl 'localhost:2017/reload_lists' && curl 'localhost:2018/reload_lists'"
}

FETCHER=`executer 'hostlist %mail_common_catdog_config-fetcher' 2>&1 | fgrep 'qloud-c.yandex.net'`

ssh $FETCHER 'bash /app/cron/worker.sh'

echo -e "\nS3 reloaded$END\n"
$ASK_TEST && read -p "Press any key to refresh prestables"

refresh

run "%mail_catdog_prestable_catdog"
run "%mail_catdog_intranet-prestable_catdog"

echo -e "\nCheck avatars in prestable\n"
$ASK_PROD && read -p "Press any key to refresh productions"

refresh

run "%mail_catdog_production"
run "%mail_catdog_intranet-production"

echo -e "\nCheck avatars in production\n"
