from mail.catdog.config_fetcher.src.bunker import Bunker, NodeVersion
from mail.catdog.config_fetcher.src.s3 import S3
from library.python.vault_client.instances import Production as VaultClient


import os
import argparse
import asyncio
import aiohttp
import functools


async def sync_dictionary(bunker, s3, node, folder, dictionary):
    version = NodeVersion.stable if folder == 'production' else NodeVersion.latest
    content = await bunker.cat('{}/{}'.format(node, dictionary), version=version)
    s3.put_dictionary('{}/{}'.format(folder, dictionary), content)


async def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('--secret', '-s', help='YAV item', default='sec-01d34s477p8fak79sq374swfqa')
    parser.add_argument('--node', '-n', help='Bunker node prefix', default='/catdog/avatars')
    parser.add_argument('--folder', '-f', help='S3 folder', default='testing', choices=['testing', 'production'])

    args = parser.parse_args()

    vault = VaultClient(
        authorization='OAuth ' + os.getenv('YAV_TOKEN', ''),
        decode_files=True
    )
    secret = vault.get_version(args.secret)

    async with aiohttp.ClientSession() as session:
        bunker = Bunker(session)
        s3 = S3(secret['value']['s3.service4456.AccessKeyId'], secret['value']['s3.service4456.AccessSecretKey'])

        sync = functools.partial(sync_dictionary, bunker, s3, args.node, args.folder)
        syncs = map(sync, ['services', 'yandex_addresses', 'yandex_domains', 'yandex_team'])

        await asyncio.gather(*syncs)


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


if __name__ == '__main__':
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
