import boto3
import json


from enum import Enum


class S3Endpoint(Enum):
    stable = 'https://s3.mds.yandex.net'
    test = 'https://s3.mdst.yandex.net'


class S3(object):
    def __init__(self, access_key_id, secret_access_key, endpoint=S3Endpoint.stable, bucket='avatars'):
        self._bucket = boto3.Session(
            aws_access_key_id=access_key_id,
            aws_secret_access_key=secret_access_key
        ).resource('s3', endpoint_url=endpoint.value).Bucket(bucket)

    def put_dictionary(self, name, content):
        obj = self._bucket.Object('{}.json'.format(name))
        obj.put(Body=json.dumps(content))
