#include <boost/python.hpp>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-parameter"
#endif
#include <boost/python/suite/indexing/map_indexing_suite.hpp>
#include <boost/python/suite/indexing/vector_indexing_suite.hpp>
#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <mail/catdog/cpp/lib/db/organizations.h>
#include <mail/catdog/cpp/lib/warn.h>
#include <mail/catdog/cpp/lib/destinations.h>
#include <mail/catdog/cpp/lib/avatar.h>
#include <mail/catdog/cpp/lib/utils.h>
#include <mail/catdog/cpp/lib/db/top200.h>
#include <mail/catdog/cpp/lib/db/pdd.h>
#include <mail/catdog/cpp/lib/db/yandex.h>

#include <mail/catdog/cpp/lib/data/top200.h>
#include <mail/catdog/cpp/lib/data/yasrv.h>
#include <mail/catdog/cpp/lib/data/ytsrv.h>

#include <mail/catdog/cpp/lib/palette.h>

namespace bp = boost::python;

namespace boost_python {

bp::object shift(bp::str colorOpt) {
    std::optional<std::string> color;
    if (!colorOpt.is_none()) {
        bp::extract<std::string> str(colorOpt);
        color = str();
    }
    
    color = cpp::shift(color);

    return color ? bp::str(*color) : bp::object();
}


bp::object getKey(bp::object emailObj, bp::dict dictWithDomainsAsKeys) {
    std::string emailDomain = bp::extract<std::string>(emailObj.attr("domain"));

    const std::map<std::string, std::optional<std::string>>& mapWithDomainsAsKeys = cpp::convertDictToMap(dictWithDomainsAsKeys);

    std::optional<std::string> result = cpp::getKey(emailDomain, mapWithDomainsAsKeys);

    return result ? bp::str(*result) : bp::object();
}


bool is_warning(bp::object emailObj, bp::object ctx) {
    if (!ctx.attr("check_warn")) {
        return false;
    }

    std::string emailLocal = bp::extract<std::string>(emailObj.attr("local"));

    return cpp::is_warning(emailLocal);
}


bp::dict getMapOfTopSendersIcons() {
    return cpp::toPythonDict(cpp::getMapOfTopSendersIcons());
}


bp::dict getMapOfYandexTeamServices() {
    return cpp::toPythonDict(cpp::getMapOfYandexTeamServices());
}


bp::dict getMapOfYandexServicesIconsByDomain() {
    return cpp::toPythonDict(cpp::getMapOfYandexServicesIconsByDomain());
}


bp::dict getMapOfYandexServicesIconsByEmail() {
    return cpp::toPythonDict(cpp::getMapOfYandexServicesIconsByEmail());
}

void domainsInit(bp::list listDomains) {
    std::set<std::string> values;
    for (size_t i = 0; i < static_cast<size_t>(bp::len(listDomains)); i++) {
        values.insert(bp::extract<std::string>(listDomains[i]));
    }

    cpp::domainsInit(values);
}

bp::dict mapOfOrganizationsColors() {
    return cpp::toPythonDict(cpp::mapOfOrganizationsColors());
}

void addOrganizationColor(std::string domain, bp::object color) {
    std::optional<std::string> colorOpt;
    if (color) {
        colorOpt = bp::extract<std::string>(color);
    }

    cpp::addOrganizationColor(domain, colorOpt);
}

void setPalette(bp::list listPallete) {
    cpp::setPalette(cpp::toVector(listPallete));
}

}

BOOST_PYTHON_MODULE(cpp) {

    using namespace bp;

    class_<std::vector<std::string>>("")
        .def(vector_indexing_suite<std::vector<std::string>>())
        ;

    class_<std::map<std::string, std::string>>("")
        .def(map_indexing_suite<std::map<std::string, std::string>>())
        ;

    def("shift", boost_python::shift);

    def("getKey", boost_python::getKey);
    def("getDomainWithoutSubdomains", cpp::getDomainWithoutSubdomains);

    def("is_warning", boost_python::is_warning);

    def("getMapOfTopSendersIcons", boost_python::getMapOfTopSendersIcons);
    def("getThreeLevelsDomains", cpp::getThreeLevelsDomains, return_value_policy<reference_existing_object>());

    def("getMapOfYandexTeamServices", boost_python::getMapOfYandexTeamServices);

    def("getMapOfYandexServicesIconsByDomain", boost_python::getMapOfYandexServicesIconsByDomain);
    def("getMapOfYandexServicesIconsByEmail", boost_python::getMapOfYandexServicesIconsByEmail);

    def("isPdd", cpp::isPdd);
    def("domainsInit", boost_python::domainsInit);
    def("loadDomains", cpp::loadDomains);

    def("isYandexEmail", cpp::isYandexEmail);
    def("getListofYandexDomains", cpp::getListofYandexDomains, return_value_policy<reference_existing_object>());

    def("mapOfOrganizationsColors", boost_python::mapOfOrganizationsColors);
    def("addOrganizationColor", boost_python::addOrganizationColor);
    def("hasOrganizationColor", cpp::hasOrganizationColor);
    def("getOrganizationColor", cpp::getOrganizationColor);

    def("loadPalette", cpp::loadPalette);
    def("getPalette", cpp::getPalette, return_value_policy<reference_existing_object>());
    def("setPalette", boost_python::setPalette);

    enum_<cpp::Destination>("Destination")
        .value("bb", cpp::Destination::bb)
        .value("bb_corp", cpp::Destination::bb_corp)
        .value("ava", cpp::Destination::ava)
        ;
    def("makeDestinationByName", cpp::makeDestinationByName);
    
    class_<cpp::Avatar>("Avatar", init<const std::string&, const std::string&>((args("url","url_small"))))
        .def_readwrite("type", &cpp::Avatar::type)
        .def_readwrite("url", &cpp::Avatar::url)
        .def_readwrite("url_small", &cpp::Avatar::url_small)
        .def_readwrite("url_mobile", &cpp::Avatar::url_mobile)
        .def("as_dict", &cpp::Avatar::as_dict_py)
        ;

}
