#include <map>
#include <mail/catdog/cpp/lib/avatar.h>
#include <mail/catdog/cpp/lib/utils.h>
#include <string>


namespace cpp {

namespace py = boost::python;

Avatar::Avatar(const std::string& url, const std::string& urlSmall)
    : type("avatar")
    , url(url)
    , url_small(urlSmall)
    , url_mobile(url) 
{ }


std::map<std::string, std::string> Avatar::as_dict() {
    return {
        {"type", type}, 
        {"url", url}, 
        {"url_small", url_small}, 
        {"url_mobile", url_mobile}
    };
}


boost::python::dict Avatar::as_dict_py() {
    std::map<std::string, std::string> mapAvatarReflection = as_dict();

    boost::python::dict dictAvatarReflection = cpp::toPythonDict(mapAvatarReflection);

    return dictAvatarReflection;
}

}
