#include <mail/catdog/cpp/lib/db/organizations.h>
#include <mail/catdog/cpp/lib/db/top200.h>

#include <mail/contrib/spdlog/include/spdlog/details/format.h>
#include <library/cpp/resource/resource.h>
#include <yamail/data/deserialization/yajl.h>



namespace cpp {

MapStrOptStr loadMap() {
    std::map<std::string, std::string> jsonMapWithoutNull = 
        yamail::data::deserialization::fromJson<std::map<std::string, std::string>>(NResource::Find("etc/data/organizations.json"));

    MapStrOptStr jsonMapWithNull;
    for(auto& [key, value]: jsonMapWithoutNull) {
        jsonMapWithNull[key] = (value == "" ? std::nullopt : std::make_optional<std::string>(std::move(value))); 
    }

    return jsonMapWithNull;
}

MapStrOptStr& mapOfOrganizationsColors() {
    static MapStrOptStr mapOfOrganizationsColors = loadMap();

    return mapOfOrganizationsColors;
}

void addOrganizationColor(const std::string& domain, const std::optional<std::string>& color) {
    mapOfOrganizationsColors()[domain] = color;
}


bool hasOrganizationColor(const std::string& emailDomain) {
    std::optional<std::string> organizationNameOpt = getKey(emailDomain, mapOfOrganizationsColors());
    if (!organizationNameOpt) {
        return false;
    }

    return static_cast<bool>(mapOfOrganizationsColors()[*organizationNameOpt]);
}


std::string getOrganizationColor(const std::string& emailDomain) {
    std::optional<std::string> organizationNameOpt = getKey(emailDomain, mapOfOrganizationsColors());
    return *shift(mapOfOrganizationsColors()[*organizationNameOpt]);
}


std::optional<std::string> shift(std::optional<std::string> color) {
    if (!color || color->empty()) {
        return std::nullopt;
    }

    std::string colorValue = color.value();
    if (colorValue == "#F8F8F8") {
        return "#B8C1D9";
    }

    if (colorValue.front() == '#') {
        colorValue = colorValue.substr(1);
    }

    const int32_t i = std::stoi(colorValue, nullptr, 16);
    int32_t r = i >> 16;
    int32_t g = (i >> 8) & 0x00FF;
    int32_t b =  i & 0x0000FF;
    const double lum = (r + g + b) / (256 * 3.0);

    if (0.1 <= lum && lum <= 0.9) {
        return "#" + colorValue;
    }
    
    if (lum == 0) {
        r = 20;
        g = 20;
        b = 20;
    }

    if (lum < 0.1) {
        r = std::round(r * 1.3);
        g = std::round(g * 1.3);
        b = std::round(b * 1.3);
    }
    else if (lum > 0.9) {
        r = std::round(r * 0.9);
        g = std::round(g * 0.9);
        b = std::round(b * 0.9);
    }

    return fmt::format("#{0:02X}{1:02X}{2:02X}", r, g, b);
}

}
