#pragma once

#include <string>
#include <optional>
#include <map>

namespace cpp {

using MapStrOptStr = std::map<std::string, std::optional<std::string>>;

MapStrOptStr& mapOfOrganizationsColors();

void addOrganizationColor(const std::string& domain, const std::optional<std::string>& color);

bool hasOrganizationColor(const std::string& emailDomain);

std::string getOrganizationColor(const std::string& emailDomain);

std::optional<std::string> shift(std::optional<std::string> color);

}
