#include <mail/catdog/cpp/lib/db/pdd.h>

#include <mail/butil/include/butil/network/idn.h>
#include <contrib/libs/cxxsupp/libcxx/include/codecvt>

#include <fstream>
#include <boost/algorithm/string.hpp>


namespace cpp {

std::set<std::string> domains = {};

void domainsInit(const std::set<std::string>& _domains) {
    domains = _domains;
}

void domainsInsert(const std::string& domain) {
    domains.insert(domain);
}

bool domainsCheckDomain(const std::string& domain) {
    return domains.count(domain);
}

bool isPdd(const std::string& emailDomain) {
    const std::string& decodedDomain = idna::encode(emailDomain);

    return domainsCheckDomain(emailDomain) || domainsCheckDomain(decodedDomain);
}

void loadDomains(std::string_view domainsPath) {
    std::ifstream fin(domainsPath);

    std::set<std::string> domains;

    std::string buffer;
    while(std::getline(fin, buffer)) {
        boost::trim(buffer);

        domains.insert(buffer);
    }

    domainsInit(domains);

    fin.close();
}


}
