#include <vector>
#include <set>
#include <algorithm>
#include <boost/algorithm/string.hpp>

#include <mail/catdog/cpp/lib/data/top200.h>
#include <mail/catdog/cpp/lib/db/top200.h>


std::string cpp::getDomainWithoutSubdomains(const std::string& emailDomain) {
    std::vector<std::string> domains;
    boost::split(domains, emailDomain, boost::is_any_of("."));
    
    if (domains.size() < 3) {
        return emailDomain;
    }

    std::string result = "";
    for (size_t it = std::max((size_t)0, domains.size() - 2); it < domains.size(); it++) {
        result += domains[it];
        if (it != domains.size() - 1) {
            result += ".";
        }
    }

    auto three_levels_domains = cpp::getThreeLevelsDomains();

    if (std::find(three_levels_domains.begin(), three_levels_domains.end(), result) != three_levels_domains.end()) {
        if (domains.size() >= 3) {
            result = domains[domains.size() - 3] + "." + result;
        }
    }

    return result;
}


std::optional<std::string> cpp::getKey(const std::string& emailDomain, const std::map<std::string, std::optional<std::string>>& mapWithDomainsAsKey) {
    if (mapWithDomainsAsKey.count(emailDomain) != 0) {
        return emailDomain;
    }
    else {
        const std::string& domainWithoutSubdomains = getDomainWithoutSubdomains(emailDomain);

        if (mapWithDomainsAsKey.count(domainWithoutSubdomains) != 0) {
            return domainWithoutSubdomains;
        }
    }

    return {};
}
